AC_DEFUN([AX_WITH_LIBLUA],
[
AC_ARG_WITH([lua-prefix],
            [AC_HELP_STRING([--with-lua-prefix@<:@=DIR@:>@],
                            [Lua files are in DIR])])
AC_ARG_WITH([lua-inc],
            [AC_HELP_STRING([--with-lua-inc@<:@=DIR@:>@],
                            [Lua include files are in DIR])])
AC_ARG_WITH([lua-lib],
            [AC_HELP_STRING([--with-lua-lib@<:@=DIR@:>@],
                            [Lua library files are in DIR])])
AC_ARG_WITH([lua-suffix],
            [AC_HELP_STRING([--with-lua-suffix@<:@=SUFFIX@:>@],
                            [Lua binary and library files are suffixed with
                             SUFFIX])])

dnl LUA
if test "x$with_lua_prefix" = x; then
    lua_search_path="$PATH"
else
    lua_search_path="$with_lua_prefix/bin"
fi
if test "x$LUA" = x; then
    AC_PATH_PROG([LUA], [lua$with_lua_suffix], [], [$lua_search_path])
    test "x$LUA" = x && AC_MSG_FAILURE([*** Can't build without Lua])
fi

dnl lua_version
AC_MSG_CHECKING([for Lua version >= 5.1])
lua_version=$($LUA -v 2>&1 | head -n 1 | cut -d' ' -f2)
case $lua_version in
5.1*)
    AC_MSG_RESULT([yes (found $lua_version)])
    AC_DEFINE([LUA_VERSION_NUM], [501], [Description])
    ;;
5.2*)
    AC_MSG_RESULT([yes (found $lua_version)])
    AC_DEFINE([LUA_VERSION_NUM], [502], [Description])
    ;;
5.3*)
    AC_MSG_RESULT([yes (found $lua_version)])
    AC_DEFINE([LUA_VERSION_NUM], [503], [Description])
    ;;
*)
    AC_MSG_RESULT([no (found $lua_version)])
    AC_MSG_FAILURE([*** Can't build without Lua 5.1 or higher])
    ;;
esac

dnl LUA_INC
if test "x$with_lua_inc" != x; then
    LUA_INC="-I$with_lua_inc"
elif test "x$with_lua_prefix" != x; then
    LUA_INC="-I$with_lua_prefix/include"
fi

save_CPPFLAGS=$CPPFLAGS
CPPFLAGS="$CPPFLAGS $LUA_INC"
AC_CHECK_HEADERS([lua.h lualib.h], [],
                 [AC_MSG_FAILURE([*** missing headers lua.h or lualib.h.
                  *** install the Lua dev package or check --with-lua-inc option.])],)

dnl LUA_LIB
if test "x$with_lua_lib" != x; then
    LUA_LIB="-L$with_lua_lib"
elif test "x$with_lua_prefix" != x; then
    LUA_LIB="-L$with_lua_prefix/lib"
fi

save_LDFLAGS=$LDFLAGS
LDFLAGS="$LDFLAGS $LUA_LIB"
AC_CHECK_LIB([lua$with_lua_suffix],
             [lua_type],
             [LUA_LIB="$LUA_LIB -llua$with_lua_suffix $lua_extra_libs"],
             [AC_MSG_FAILURE([*** Can't find lua_type in lua$with_lua_suffix.
                  *** Check for liblua installation or --with-lua-lib or --with-lua-suffix options])],
             [$LUA_LIB $lua_extra_libs])

CPPFLAGS=$save_CPPFLAGS
LDFLAGS=$save_LDFLAGS

AC_SUBST(LUA_CFLAGS,$LUA_INC)
AC_SUBST(LUA_LIBS,$LUA_LIB)
])
