LIBXML_REQUIRED_VERSION=2.6.5

AC_DEFUN([VERSION_TO_NUMBER],
   [`$1 | sed -e 's/libxml //' | awk 'BEGIN { FS = "."; } { printf "%d", ([$]1 * 1000 + [$]2) * 1000 + [$]3;}'`])

AC_DEFUN([AX_WITH_LIBXML2],
[
LIBXML_CONFIG_PREFIX=""

AC_ARG_WITH(libxml-prefix,
  AC_HELP_STRING([--with-libxml-prefix=PREFIX],
                 [Specify location of libxml config]),
  LIBXML_CONFIG_PREFIX=$withval
)
        
AC_ARG_WITH(libxml-inc,
  AC_HELP_STRING([--with-libxml-inc=DIR],
                 [Specify location of libxml headers]),
        LIBXML_CFLAGS="-I$withval"
)

AC_ARG_WITH(libxml-lib,
  AC_HELP_STRING([--with-libxml-lib=DIR],
                 [Specify location of libxml libraries]),
        LIBXML_LIBS="-L$withval"
)

dnl
dnl where is xml2-config
dnl

AC_SUBST(LIBXML_REQUIRED_VERSION)
AC_MSG_CHECKING(for libxml libraries >= $LIBXML_REQUIRED_VERSION) 
if test "x$LIBXML_CONFIG_PREFIX" != "x"
then
        XML_CONFIG=${LIBXML_CONFIG_PREFIX}/bin/xml2-config
else
        XML_CONFIG=xml2-config
fi

dnl check version number
if ${XML_CONFIG} --libs print > /dev/null 2>&1
then
	XMLVERS=`$XML_CONFIG --version`
	if test VERSION_TO_NUMBER(echo $XMLVERS) -ge VERSION_TO_NUMBER(echo $LIBXML_REQUIRED_VERSION)
	then
		LIBXML_LIBS="$LIBXML_LIBS `$XML_CONFIG --libs`"
		LIBXML_CFLAGS="$LIBXML_CFLAGS `$XML_CONFIG --cflags`"
		AC_MSG_RESULT($XMLVERS found)
	else
		AC_MSG_ERROR(Version $XMLVERS found. You need at least libxml2 $LIBXML_REQUIRED_VERSION for this version of ProLinga-Soap)
	fi
else
	AC_MSG_ERROR([Could not find libxml2 anywhere, check http://xmlsoft.org/.])
fi
AC_SUBST(XML_CONFIG)
AC_SUBST(LIBXML_CFLAGS)
AC_SUBST(LIBXML_LIBS)

])
