AC_DEFUN([AX_ENABLE_WMS],
[
have_wms=no
AC_ARG_ENABLE(wms,
  AC_HELP_STRING([--enable-wms], [Enable WMS client (libcurl is required)]),
  [use_wms=$enableval], [use_wms=auto])

if test "x$use_wms" == "xyes"; then

AC_ARG_WITH(curl_config,
  AC_HELP_STRING([--with-curl-config], [path to curl-config program]),
  ,
  [with_curl_config=yes]
)
if test "$with_curl_config" = "yes"; then
  AC_PATH_PROG(CURLCONFIG, curl-config)
elif test "$with_curl_config" = "no"; then
    AC_MSG_ERROR(curl-config is required and cannot be disabled)
else
  AC_MSG_CHECKING(for curl-config usability in $with_curl_config)
  if test -x "$with_curl_config"; then
    CURLCONFIG=$with_curl_config
    AC_MSG_RESULT(yes)
  else
    AC_MSG_ERROR($with_curl_config not found or not executable)
  fi
fi
if test -z "$CURLCONFIG"; then
  AC_MSG_ERROR(curl-config utility not found. use --with-curl-config to specify its location.)
fi
AC_SUBST(CURLCONFIG)
AC_SUBST(CURL_CFLAGS,`$CURLCONFIG --cflags`)
AC_SUBST(CURL_LIBS,`$CURLCONFIG --libs`)
AC_DEFINE(ENABLE_WMS, 1, [Define to 1 if you use WMS connection])
have_wms=yes

else
    echo "WMS support disabled."
fi
])
