/**
 * @file      canvas_pngio.h
 * @brief     PNG IO support for canvas.
 * @date      2010-05-26
 *
 * @copyright
 * Copyright 2010 AstroArts Inc.
 *
 */

#ifndef _CANVAS_PNGIO_H
#define _CANVAS_PNGIO_H

#include <png.h>
#include "canvas.h"

__BEGIN_DECLS
/**
 * @brief Load a PNG file
 * @param[in] path  the file path of a PNG file to load
 * @result cv_load_png() returns the canvas instance. you must call
 *         canvas_free() at done.
 */
canvas* cv_load_png(const char* path);

/**
 * @brief Load PNG data from a file stream
 *
 * @param[in]  io  FILE stream.
 * @return cv_load_png_with_std() returns a pointer of canvas instance
 * if sucessful, NULL otherwise.
 */
canvas* cv_load_png_with_std(FILE* io);

/**
 * @brief Load PNG data from memory
 *
 * @param[in]  ptr  begnning address of memory
 * @param[in]  size data size
 * @param cv_load_png_with_bytes() returns a pointer of canvas instance
 * if sucessful, NULL otherwise.
 */
canvas* cv_load_png_with_bytes(const void* ptr, size_t size);

/**
 * @param Save canvas data into a PNG file
 *
 * @param[in]  self        canvas instance
 * @param[in]  path        output filepath
 * @param[in]  compression compression Level [1-9]
 * @return cv_save_png() returns 1 if sucessful, 0 otherwise.
 */
int cv_save_png(canvas* self, const char* path, int compression);

/**
 * @param Save canvas data into a file stream
 *
 * @param[in]  self        canvas instance
 * @param[in]  io          file I/O
 * @param[in]  compression compression Level [1-9]
 * @return cv_save_png_with_std() returns 1 if sucessful, 0 otherwise.
 */
int cv_save_png_with_std(canvas* self, FILE* io, int compression);

__END_DECLS

#endif // _CANVAS_PNGIO_H
