/**
 * @file      epd.h
 * @brief     ExPanDable file format
 * @date      2011-03-11
 *
 * @copyright
 * Copyright 2010-2011 Japan Aerospace Exploration Agency
 *
 */

#ifndef _EPD_H
#define _EPD_H

#define EPD_VERSION            0x00010000U /* 1.0.0 */

#define EPD_MAGIC               "EPDF"
#define EPD_MAGIC_SIZE          4

#define EPD_DEBUG_LEVEL_NONE    0
#define EPD_DEBUG_LEVEL_ERRROR  1
#define EPD_DEBUG_LEVEL_NOTICE  2
#define EPD_DEBUG_LEVEL_WARN    3
#define EPD_DEBUG_LEVEL_INFO    4
typedef int epd_debug_level;

#define EPD_TRUE  1
#define EPD_FALSE 0
typedef char epd_bool;

#define EPD_DEFAULT_BLOCK_SIZE  64
#define EPD_EMPTY_INDEX         ((uint32_t)(-1))

#define EPD_NO_ERROR            0
#define EPD_INVALID_OPEN_MODE   1
#define EPD_FILE_NOT_FOUND      2
#define EPD_FILE_OPEN_ERROR     3
#define EPD_PERMISSION_DENIED   4
#define EPD_MEMORY_OVERFLOW     5
#define EPD_MEMORY_FULL         6
#define EPD_INVALID_FORMAT      7
#define EPD_WRITE_NOT_ALLOW     8
#define EPD_WRITE_ERROR         9
#define EPD_SEEK_ERROR         10
#define EPD_READ_ERROR         11
#define EPD_INVALID_VERSION    12
#define EPD_FILE_CLOSE_ERROR   13
#define EPD_CHUNK_NOT_FOUND    14
typedef int32_t epd_status;

#define EPD_RDONLY     1
#define EPD_WRONLY     2
#define EPD_RDWR       (EPD_RDONLY|EPD_WRONLY)
#define EPD_CREAT      4
typedef int32_t epd_opmode;

#define EPD_CHUNK_START        1
#define EPD_CHUNK_PART         2
typedef int32_t epd_block_type;

typedef struct _epd_config {
  uint32_t block_size;
  epd_debug_level debug_level;
  epd_bool write_sync;
} epd_config;

typedef struct _epd {
  uint32_t version;
  int fd;
  epd_opmode mode;
  uint32_t block_size;
  uint32_t block_start;
  epd_config config;
  epd_debug_level debug_level;
  epd_bool write_sync;
} epd;

typedef struct _epd_chunk_head {
  uint32_t index;
  uint32_t size;
  uint32_t njoin;
  uint32_t offset;
  uint32_t start;
  uint32_t next;
  uint32_t previous;
  char type;
  char used;
} epd_chunk_head;

__BEGIN_DECLS;
epd* epd_open(const char* path, epd_opmode mode, const epd_config* conf);
epd_status epd_close(epd* self);
epd_status epd_read_chunk_head(epd* self, int32_t index, epd_chunk_head* chead);
epd_status epd_read(epd* self, epd_chunk_head* chead, void* data);
size_t epd_pread(epd* self, epd_chunk_head* chead, size_t offset, size_t size, void* data);
epd_status epd_reserve(epd* self, size_t size, epd_chunk_head* chead);
epd_status epd_unlink(epd* self, epd_chunk_head* chead);
epd_status epd_write(epd* self, epd_chunk_head* chead, size_t size, const void* data);
epd_status epd_pwrite(epd* self, epd_chunk_head* chead, size_t offset, size_t size, void* data);
epd_status epd_add(epd* self, size_t size, void* data, epd_chunk_head* chead);
size_t epd_pread(epd* self, epd_chunk_head* chead, size_t offset, size_t size, void* data);
epd_status epd_pwrite(epd* self, epd_chunk_head* chead, size_t offset, size_t size, void* data);
void epd_dump_header(epd* self);
__END_DECLS;

#endif /* _EPD_H */
