/**
 * @file      flowig_config.h
 * @brief     flow_ig option analysis
 * @date      2010-03-12
 *
 * @copyright
 * Copyright 2010 Japan Aerospace Exploration Agency
 *
 */

#ifndef _FLOWIG_CONFIG_H
#define _FLOWIG_CONFIG_H

#include "flow_common.h"

#ifdef HAVE_CFITSIO
#include "canvas_fitsio.h"
#endif

typedef struct tagFLOWIGConfig {
  int help;                         /* help (-h) */
  int version;                      /* version (-V) */
  int xmlerror;                     /* xml error message */
  int flip;                         /* vertical flip fists format (-f) */
  int monochrome;                   /* generate monochrome image (-m) */

#ifdef ENABLE_WMS
  int wms_exit_on_error;            /* exit process when WMS error (-r wms_exit_on_error) */
  int wms_no_cache;                 /* don't use cache (-r wms_no_cache) */
  int wms_delete_cache;             /* remove cache befor run (-r wms_delete_cache) */
#endif
  int ge_wire;                      /* wire-frame rendering (-r ge_wire) */
  int ge_disable_light;             /* no lighting (-r ge_disable_light) */

#ifdef HAVE_CFITSIO
  int fitsformat;                   /* fits rgb format */
#endif

#ifdef HAVE_JPEGLIB_H
  int jpeg_quality;                 /* jpeg compression qualigh [1 - 100] */
#endif

#ifdef HAVE_LIBPNG
  int png_compression_level;        /* PNG compression level [0 - 9] */
#endif
  double scale;
  char* input_file;
  char* output_file;
  char* error_message;
  enum FLOWImageFormat output_format;       /* output format (-t) */
} FLOWIGConfig;

__BEGIN_DECLS

FLOWIGConfig* flowigconf_create(void);
int flowigconf_parse_option(FLOWIGConfig* self, int argc, char** argv);
void flowigconf_print_message(FLOWIGConfig* self);
void flowigconf_free(FLOWIGConfig* self);

__END_DECLS

#endif /* _FLOWIG_CONFIG_H */
