/**
 * @file      flowse_config.h
 * @brief     flow_se option analysis
 * @date      2010-03-12
 *
 * @copyright
 * Copyright 2010 Japan Aerospace Exploration Agency
 *
 */

#ifndef _FLOWSE_CONFIG_H
#define _FLOWSE_CONFIG_H

typedef struct tagFLOWSEConfig {
  int help;                  /* help (-h) */
  int version;               /* version (-V) */
  char* config_file;         /* LUA formatted configuration file (-c) */
  char* output_file;         /* XML output path (-o) */
  char* datetime;            /* simulation datatime (-d) */
  char* error_message;
} FLOWSEConfig;

__BEGIN_DECLS

FLOWSEConfig* flowseconf_create(void);
int flowseconf_parse_option(FLOWSEConfig* self, int argc, char** argv);
void flowseconf_print_message(FLOWSEConfig* self);
void flowseconf_free(FLOWSEConfig* self);

__END_DECLS

#endif /* _FLOWSE_CONFIG_H */
