/**
 * @file      fsync.c
 * @brief     Support for MinGW
 * @date      2014-05-23
 *
 * @copyright
 * Copyright 2014 Japan Aerospace Exploration Agency
 *
 */

#if defined(__MINGW32__)

#include <windows.h>
#include <io.h>

int fsync(int fd)
{
  return (FlushFileBuffers((HANDLE)_get_osfhandle(fd))) ? 0 : -1;
}

#endif
