/**
 * @file      mkstemp.c
 * @brief     Support for MinGW
 * @date      2014-05-23
 *
 * @copyright
 * Copyright 2014 Japan Aerospace Exploration Agency
 *
 */

#if defined(__MINGW32__)

#include <stddef.h>
#include <fcntl.h>
#include <unistd.h>

int mkstemp(char* template)
{
  char* filename = mktemp(template);
  if (filename == NULL) {
    return -1;
  }
  return open(filename, O_RDWR | O_CREAT, 0600);
}

#endif
