/**
 * @file      regscan.h
 * @brief     Regular expression wrapper object
 * @date      2011-03-11
 *
 * @copyright
 * Copyright 2011 Japan Aerospace Exploration Agency
 *
 */

#ifndef _REGSCAN_H
#define _REGSCAN_H

#include <sys/types.h>
#include <regex.h>

#define REGSCAN_NMATCH  20

typedef int regscanStatus;
#define REGSCAN_STATUS_NO_ERROR         0
#define REGSCAN_STATUS_MATCH            0
#define REGSCAN_STATUS_NOT_MATCH        1
#define REGSCAN_STATUS_COMPILE_ERROR    2
#define REGSCAN_STATUS_MEMORY_FULL      3
#define REGSCAN_STATUS_NOT_SET          4
#define REGSCAN_STATUS_INDEX_UNDERFLOW  5
#define REGSCAN_STATUS_INDEX_OVERFLOW   6
#define REGSCAN_STATUS_BUFFER_TOO_SHORT 7

typedef struct _regscan {
  const char* str;
  const char* rest;
  regmatch_t match[REGSCAN_NMATCH];
  regex_t re;
  int compiled;
} regscan;

__BEGIN_DECLS
regscan* regscan_create();
void regscan_free(regscan* self);

void regscan_clear(regscan* self);
regscanStatus regscan_compile(regscan* self, const char* pattern, int cflags);
regscanStatus regscan_test(regscan* self, const char* pattern, const char* str, int cflags);
regscanStatus regscan_exec(regscan* self, const char* str);
regscanStatus regscan_gexec(regscan* self, const char* str);
const char* regscan_match(regscan* self, int index, int* length);
regscanStatus regscan_cpmatch(regscan* self, int index, int nmemb, char* str, int* length);
__END_DECLS

#endif /* _REGSCAN_H */
