/**
 * @file      shape_model.c
 * @brief     Shape model implementation
 * @date      2012/08/15
 *
 * @copyright
 * 2012 Japan Aerospace Exploration Agency. All rights reserved.
 *
 * @par       History:
 * - 2012/08/15 Y. Yamamoto
 *   -# Separate STL and shape model instance
 *
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "shape_model.h"

shape_model* shape_create() {
  return (shape_model *)calloc(1, sizeof(shape_model));
}

void shape_free(shape_model* self) {
  if (self) {
    if (self->triangle) {
      free(self->triangle);
    }
    free(self);
  }
}

size_t shape_size(const shape_model* self) {
  return self->size;
}

const shapeTriangle* shape_triangle(const shape_model* self) {
  return self->triangle;
}

const shapeTriangle* shape_triangle_at(const shape_model* self, size_t index) {
  return &self->triangle[index];
}

ShapeBool shape_push_triangle(shape_model* self, const shapeTriangle* tri) {
  if (self->size == self->capacity) {
    if (!shape_extend(self, self->capacity * SHAPE_CAPACITY_MAGNIFICATION_FACTOR)) {
      return SHAPE_FALSE;
    }
  }
  self->triangle[self->size] = *tri;
  self->size++;
  return SHAPE_TRUE;
}

ShapeBool shape_extend(shape_model* self, size_t size) {
  shapeTriangle* tri;
  if (0 == self->capacity) {
    size = (size < 1) ? 128 : size;
    tri = (shapeTriangle *)malloc(sizeof(shapeTriangle) * size);
    if (!tri) {
      return SHAPE_FALSE;
    }
  }
  else if (self->capacity > size) {
    return SHAPE_TRUE;
  }
  else {
    tri = (shapeTriangle *)realloc(self->triangle, sizeof(shapeTriangle) * size);
    if (!tri) {
      return SHAPE_FALSE;
    }
  }
  self->capacity = size;
  self->triangle = tri;
  return SHAPE_TRUE;
}
