/**
 * @file      spice_cell_lua.h
 * @brief     LUA binding for spice_cell
 * @date      2010-03-12
 *
 * @copyright
 * Copyright 2010 Japan Aerospace Exploration Agency
 *
 */

/*
 * SpyceCell Lua provide these functions.
 *
 * cell spice_cell()
 * int #cell
 * mixed cell[#]
 *
 */

#ifndef _SPICE_CELL_LUA_H
#define _SPICE_CELL_LUA_H

#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>
#include "SpiceUsr.h"

#define SpiceCellMetatableKey "SpiceCellMetatable"

__BEGIN_DECLS
SpiceCell* spice_cell_lua_create(lua_State* L, int type, int size, int len);
void spice_cell_lua_free(lua_State* L, SpiceCell* cell);
void spice_cell_lua_init(lua_State* L);
__END_DECLS

#endif /* _SPICE_CELL_LUA_H */
