/**
 * @file      spice_dsk.c
 * @brief     SPICE DSK support
 * @date      2012/08/15
 *
 * @copyright
 * Copyright 2012 Japan Aerospace Exploration Agency
 *
 * @sa ftp://naif.jpl.nasa.gov/pub/naif/generic_kernels/dsk/
 * @sa ftp://naif.jpl.nasa.gov/pub/naif/misc/alpha_dsk/
 *
 * @par       History:
 * - 2012/08/15 Y. Yamamoto
 *   -# SPICE DSK Type 2 support (Experimental)
 *
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#ifdef ENABLE_SPICE_DSK

#include <SpiceUsr.h>
#include <SpiceDSK.h>
#include "shape_model.h"
#include "spice_dsk.h"

#define PBUFSIZ 10000

ShapeBool dsk_type02_load(shape_model* self, const char* filename, int* code) {

  shapeTriangle tri;

  SpiceInt handle;
  SpiceBoolean found;
  SpiceDLADescr dladsc;
  SpiceInt nv, np;
  SpiceInt i, j;
  SpiceInt start;
  SpiceInt nread;
  SpiceInt n;
  SpiceInt plates[PBUFSIZ][3];
  SpiceInt plix;
  SpiceDouble verts[3][3];
  SpiceDouble normal [3];
  SpiceInt nvtx;

  dasopr_c(filename, &handle);
  dlabfs_c(handle, &dladsc, &found);
  if (!found) {
    *code = DSK_ERROR_DLA_SEGMENT_NOT_FOUND;
    return SHAPE_FALSE;
  }

  dskz02_c(handle, &dladsc, &nv, &np);
  if (!shape_extend(self,np)) {
    *code = DSK_ERROR_NOT_ENOUGH_MEMORY;
    return SHAPE_FALSE;
  }

  start  = 1;
  while(np > 0) {
    nread = mini_c(2, PBUFSIZ, np);
    dskp02_c(handle, &dladsc, start, nread, &n, plates);

    for(i=0; i<nread; ++i) {
      plix = start + i;

      for(j=0; j<3; ++j) {
        dskv02_c(handle, &dladsc, plates[i][j], 1,
                 &nvtx, (SpiceDouble(*)[3])verts[j]);
      }

      dskn02_c ( handle, &dladsc, plix, normal );

      tri.normal.x = normal[0];
      tri.normal.y = normal[1];
      tri.normal.z = normal[2];

      tri.va.x = verts[0][0];
      tri.va.y = verts[0][1];
      tri.va.z = verts[0][2];

      tri.vb.x = verts[1][0];
      tri.vb.y = verts[1][1];
      tri.vb.z = verts[1][2];

      tri.vc.x = verts[2][0];
      tri.vc.y = verts[2][1];
      tri.vc.z = verts[2][2];

      tri.attr = 0;

      shape_push_triangle(self, &tri);
    }
    start += nread;
    np -= nread;
  }
  dascls_c(handle);

  return SHAPE_TRUE;
}

#endif /* ENABLE_SPICE_DSK */
