/**
 * @file      spice_dsk.h
 * @brief     Header file of SPICE DSK support
 * @date      2012/08/15
 *
 * @copyright
 * Copyright 2012 Japan Aerospace Exploration Agency
 *
 * @sa ftp://naif.jpl.nasa.gov/pub/naif/generic_kernels/dsk/
 * @sa ftp://naif.jpl.nasa.gov/pub/naif/misc/alpha_dsk/
 *
 * @par       History:
 * - 2012/08/15 Y. Yamamoto
 *   -# SPICE DSK Type 2 support (Experimental)
 *
 */

#ifndef __SPICE_DSK_H__
#define __SPICE_DSK_H__

#define DSK_ERROR_NONE                  0
#define DSK_ERROR_DLA_SEGMENT_NOT_FOUND 1
#define DSK_ERROR_NOT_ENOUGH_MEMORY     2

__BEGIN_DECLS

/**
 * @brief Load SPICE DSK Type 2 (Shape model using triangular plates)
 *
 * @param[in]   self      the pointer of the shape_model instance
 * @param[in]   filename  the name of SPICE DSK
 * @param[out]  code      error code if an error occurs
 * @return      dsk_load() returns SHAPE_TRUE if DSK data is successfully
 *              loaded. Otherwise, SHAPE_FALSE is returned and an error code
 *              is stored into parameter code.
 */
ShapeBool dsk_type02_load(shape_model* self, const char* filename, int* code);

__END_DECLS

#endif
