/**
 * @file      starimage.c
 * @brief     create star texture
 * @date      2012-08-23
 *
 * @copyright
 * Copyright 2010 AstroArts Inc.
 *
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>
#include "starimage.h"

static int StarDiam[] = {1, 1, 3, 3, 3, 4, 5, 6};

static char Star1[] = {0x99};
static char Star2[] = {0xFF};
static char Star3[] = {0x00, 0x99, 0x00,
                       0x99, 0xFF, 0x99,
                       0x00, 0x99, 0x00};
static char Star4[] = {0x00, 0xCC, 0x00,
                       0xCC, 0xFF, 0xCC,
                       0x00, 0xCC, 0x00};
static char Star5[] = {0x99, 0xFF, 0x99,
                       0xFF, 0xFF, 0xFF,
                       0x99, 0xFF, 0x99};
static char Star6[] = {0x00, 0xCC, 0xCC, 0x00,
                       0xCC, 0xFF, 0xFF, 0xCC,
                       0xCC, 0xFF, 0xFF, 0xCC,
                       0x00, 0xCC, 0xCC, 0x00};
static char Star7[] = {0x00, 0x99, 0xFF, 0x99, 0x00,
                       0x99, 0xFF, 0xFF, 0xFF, 0x99,
                       0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                       0x99, 0xFF, 0xFF, 0xFF, 0x99,
                       0x00, 0x99, 0xFF, 0x99, 0x00};
static char Star8[] = {0x00, 0x00, 0x99, 0x99, 0x00, 0x00,
                       0x00, 0xCC, 0xFF, 0xFF, 0xCC, 0x00,
                       0x99, 0xFF, 0xFF, 0xFF, 0xFF, 0x99,
                       0x99, 0xFF, 0xFF, 0xFF, 0xFF, 0x99,
                       0x00, 0xCC, 0xFF, 0xFF, 0xCC, 0x00,
                       0x00, 0x00, 0x99, 0x99, 0x00, 0x00};


canvas* starimage_create(int magidx)
{
  int cw = 16;
  int ch = 16;
  int cx = cw/2;
  int cy = ch/2;
  int ox, oy;
  int x, y;
  int d, off;
  canvas* cv;
  char* star_map[] = {Star1, Star2, Star3, Star4, Star5, Star6, Star7, Star8};
  char* star_pt;
  char* star;
  unsigned char clear[] = {0xff, 0x00};

  assert(0 <= magidx);
  assert(magidx < 8);

  star = star_map[magidx];
  d = StarDiam[magidx];
  star_pt = star_map[magidx];
  cv = cv_create(cw, ch, CVDepthGA8);
  if (!cv) {
    return NULL;
  }
  cv_draw_rect_ex(cv, 0, 0, cw, ch, CVDepthGA8, clear, CVBlendNone);
  // #223 -1 adjustment of texture center position
  ox = cx - d/2 - 1;
  oy = cy - d/2 - 1;
  for (y = 0; y < d; y++) {
    for (x = 0; x < d; x++) {
      off = y * d + x;
      cv_set_pixel_gray8(cv, ox+x, oy+y, star_pt[off]);
    }
  }
  return cv;
}
