/**
 * @file      stl_parser.rl
 * @brief     STL parser
 * @date      2011-03-11
 *
 * @copyright
 * Copyright 2011 Japan Aerospace Exploration Agency
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "stl.h"

%%{
	machine stl_parser;
	
	######################################################################
	# PATTERN
	######################################################################
	RETURN = '\n';
	SIGN   = ('+' | '-');
	INT    = SIGN? digit+;
	REAL   = SIGN? digit+ '.' digit+;
	REAL2  = SIGN? digit '.' digit+ SIGN 'e' digit+;
	NUM    = (REAL2 | REAL | INT);
	SP     = space+;

	######################################################################
	# ACTIONS
	######################################################################
	action report_error {
		fprintf(stderr, "ERROR.\n");
	}
	action normal_start {
		//printf("normal_start\n");
		npos = 0;
	}
	action vertex_start {
		npos = 0;
	}
	action num_init {
		//printf("num_init\n");
		ss = p;
	}
	action normal_hook {
		v = strtod(ss, NULL);
		//printf("normal_hook npos: %d v: %f\n", npos, v);
		switch (npos) {
			case 0: tri.normal.x = v; break;
			case 1: tri.normal.y = v; break;
			case 2: tri.normal.z = v; break;
		}
		npos++;
	}
	action vertex_hook {
		//printf("vertex_hook\n");
		v = strtod(ss, NULL);
		switch (vpos*3+npos) {
			case 0: tri.va.x = v; break;
			case 1: tri.va.y = v; break;
			case 2: tri.va.z = v; break;
			case 3: tri.vb.x = v; break;
			case 4: tri.vb.y = v; break;
			case 5: tri.vb.z = v; break;
			case 6: tri.vc.x = v; break;
			case 7: tri.vc.y = v; break;
			case 8: tri.vc.z = v; break;
		}
		npos++;
	}
	action vertex_end {
		vpos++;
	}
	action tri_init {
		//printf("tri_init #%d\n", count);
		tri.attr = 0;
		vpos = 0;
		npos = 0;
	}
	action tri_push {
		//printf("tri_push #%d\n", count);
		count++;
		shape_push_triangle(self, &tri);
	}

	######################################################################
	# MACHINE
	######################################################################
	NAME   = [^\n]*;
	ESOLID = 'endsolid' SP NAME;
	VERTEX_ARG = NUM >num_init %vertex_hook;
	VERTEX = 'vertex' %vertex_start (SP VERTEX_ARG){3} %vertex_end;
	LOOP   = 'loop' (SP VERTEX){3} SP 'endloop';
	OUTER  = 'outer' SP LOOP;
	NORMAL_ARG = NUM >num_init %normal_hook;
	NORMAL = 'normal' %normal_start (SP NORMAL_ARG){3};
	FACET  = 'facet' %tri_init SP NORMAL SP OUTER SP 'endfacet' %tri_push;
	SOLID  = 'solid' SP NAME '\n' space* (FACET SP)* ESOLID;

	main := SOLID any*;
}%%

%%write data;

int stl_parse_data_text(shape_model *self, char *source) {
	int cs;
	char *p = source;
	char *pe = p + strlen(p);
	/*char *eof = NULL;*/
	char *ss;
	shapeTriangle tri;
	size_t count = 0;
	int npos = 0;
	int vpos = 0;
	double v;

	%%write init;
	
	%%write exec;
	
	if (cs < %%{ write first_final; }%%) {
		fprintf(stderr, "parse error\n");
		return 0;
	}

	return 1;
}

