/**
 * @file      triangle.h
 * @brief     drawing triangle polygon
 * @date      2017-05-20
 *
 * @copyright
 * Copyright 2010 AstroArts Inc.
 *
 */

#ifndef _TRIANGLE_H
#define _TRIANGLE_H

#include "canvas.h"
#include "zbuf.h"

typedef unsigned long COLORREF;

typedef struct _CSDPoint {
  double m_fX;
  double m_fY;
} CSDPoint;

typedef struct _STL_DRAWTRI {
  CSDPoint po[3];
  double z[3];
  COLORREF clrVtx[3];
  double fUU[3];
  double fVV[3];
} STL_DRAWTRI, * PSTL_DRAWTRI;

__BEGIN_DECLS

//////////////////////////////////////////////////////////////////////
// begin - end
//////////////////////////////////////////////////////////////////////
/**
 * レンダリングエンジンを初期化します。
 * レンダリングが完了したら必ず tri_end を呼び出してください。
 */
void tri_begin(canvas* screen, zbuf* zbuffer, canvas* texture);

/**
 * レンダリングエンジンを開放します。
 */
void tri_end();

/**
 * テクスチャを設定します。
 * @param texture  テクスチャイメージ。NULL で解除。
 */
void tri_set_texture(canvas* texture);

/**
 * Z-Buffer の有効・無効を設定します。
 */
void tri_set_depth_test(int flag);

/**
 * Z-Buffer の書き込みの有効・無効を設定します。
 */
void tri_set_depth_mask(int flag);

/**
 * カラーブレンドの有効・無効を設定します。
 */
void tri_set_blend(int flag);

/**
 * カラーブレンド方法を設定します。
 * @param sfactor source factor. cv_blend_pixel2() へ渡る値です。
 * @param dfactor destination factor. cv_blend_pixel2() へ渡る値です。
 */
void tri_set_blend_func(int sfactor, int dfactor);

/**
 * 三角形ポリゴンを描画します。
 */
void StlDrawTriangle(PSTL_DRAWTRI pStlDrawTri);

__END_DECLS

#endif // _TRIANGLE_H
