/**
 * @file      wms_error.h
 * @brief     set/get error property of wms
 * @date      2011-03-11
 *
 * @copyright
 * Copyright 2010-2011 Japan Aerospace Exploration Agency
 *
 */

#ifndef _WMS_ERROR_H
#define _WMS_ERROR_H

#include <stdarg.h>
#include "wms.h"

#define wmsError_set(s,c,m)  \
  wmsError_set_ex((s),(c),(__func__),(__FILE__),(__LINE__),(m))

__BEGIN_DECLS
wmsError* wmsError_create();
void wmsError_free(wmsError* self);

void wmsError_set_ex(wmsError* self, enum WMSErrorCode code,
                     const char* function, const char* file, int32_t line,
                     const char* message);
void wmsError_format(wmsError* self, enum WMSErrorCode code,
                     const char* function, const char* file, int32_t line,
                     const char* format, ...);
void wmsError_vformat(wmsError* self, enum WMSErrorCode code,
                      const char* function, const char* file, int32_t line,
                      const char* format, va_list ap);
enum WMSErrorCode wmsError_code(wmsError* self);
const char* wmsError_message(wmsError* self);
const char* wmsError_function(wmsError* self);
const char* wmsError_file(wmsError* self);
int32_t wmsError_line(wmsError* self);
void wmsError_print(wmsError* self, FILE* io);
void wmsError_clear(wmsError* self);
__END_DECLS

#endif /* _WMS_ERROR_H */
