/**
 * @file      wms_parser.h
 * @brief     Load and parse WMS data
 * @date      2011-03-11
 *
 * @copyright
 * Copyright 2010-2011 Japan Aerospace Exploration Agency
 *
 */

#ifndef _WMS_PARSER_H
#define _WMS_PARSER_H

#include <libxml/tree.h>
#include <libxml/parser.h>
#include "wms.h"

__BEGIN_DECLS

/**
 * @brief Read WMS image from URI
 *
 * @param[in]  self  wms instance
 * @param[in]  url   URL
 * @return wms_read_from_uri() returns WMS_TRUE if success,
 * WMS_FALSE otherwise.
 */
wmsBool wms_read_from_uri(wms* self, const char* url);

/**
 * @brief Read WMS XML response from local file
 *
 * @param[in]  self  wms instance
 * @param[in]  path  file path
 * @return wms_read_from_file() returns WMS_TRUE if success,
 * WMS_FALSE otherwise.
 */
wmsBool wms_read_from_file(wms* self, const char* path);

/**
 * @brief Read WMS XML response from file stream
 *
 * @param[in]  self  wms instance
 * @param[in]  io    pointer of file stream
 * @return wms_read_from_io() returns WMS_TRUE if success,
 * WMS_FALSE otherwise.
 */
wmsBool wms_read_from_std(wms* self, FILE* io);

/**
 * @brief Read WMS XML response from memory buffer
 *
 * @param[in]  self   wms instance
 * @param[in]  url    base URL
 * @param[in]  buffer buffer
 * @param[in]  nbuf   size of buffer
 * @return wms_read_from_buffer() returns WMS_TRUE if success,
 * WMS_FALSE otherwise.
 */
wmsBool wms_read_from_buffer(wms* self, const char* url, const char* buffer, size_t nbuf);

__END_DECLS

#endif /* _WMS_PARSER_H */
