/**
 * @file      wms_res.c
 * @brief     WMS request response object
 * @date      2011-03-11
 *
 * @copyright
 * Copyright 2010-2011 Japan Aerospace Exploration Agency
 *
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "strb.h"
#include "memb.h"
#include "wms_res.h"

wmsRes* wmsRes_create(size_t size)
{
  wmsRes* self;
  self = malloc(sizeof(*self));
  if (!self) {
    return NULL;
  }
  self->content_type = strb_create(64);
  if (!self->content_type) {
    free(self);
    return NULL;
  }
  self->data = memb_create(size);
  if (!self->data) {
    strb_free(self->content_type);
    free(self);
    return NULL;
  }
  return self;
}

void wmsRes_free(wmsRes* self)
{
  if (self) {
    if (self->content_type) strb_free(self->content_type);
    if (self->data) memb_free(self->data);
    free(self);
  }
}

int wmsRes_status(wmsRes* self)
{
  return self->status;
}

const char* wmsRes_content_type(wmsRes* self)
{
  return (const char *)strb_ptr(self->content_type);
}

void* wmsRes_data(wmsRes* self)
{
  return memb_ptr(self->data);
}

size_t wmsRes_data_size(wmsRes* self)
{
  return memb_size(self->data);
}
