/**
 * @file      wms_res.h
 * @brief     WMS request response object
 * @date      2011-03-11
 *
 * @copyright
 * Copyright 2010-2011 Japan Aerospace Exploration Agency
 *
 */

#ifndef _WMS_RES_H
#define _WMS_RES_H

#include "wms.h"

__BEGIN_DECLS
wmsRes* wmsRes_create();
void wmsRes_free(wmsRes* self);

int wmsRes_status(wmsRes* self);
const char* wmsRes_content_type(wmsRes* self);
void* wmsRes_data(wmsRes* self);
size_t wmsRes_data_size(wmsRes* self);
__END_DECLS

#endif /* _WMS_RES_H */
