/**
 * @file      xml_util.h
 * @brief     libxml2 support functions
 * @date      2010-03-12
 *
 * @copyright
 * Copyright 2010 Japan Aerospace Exploration Agency
 *
 */

#ifndef _XML_UTIL_H
#define _XML_UTIL_H

#include <libxml/tree.h>
#include <libxml/xmlversion.h>

typedef void (* xml_util_walk_node_callback)(xmlNodePtr,void *);

/**
 * walk through child nodes.
 */
void xml_util_walk_element_node(xmlNodePtr node, xml_util_walk_node_callback func, void* data);

/**
 * DOM getElementsByTagName like function.
 * @param node [in] XML node.
 * @param name [in] element name.
 * @param len  [out] result length.
 * @result XML node array. call free() after use it.
 */
xmlNodePtr* xml_util_getElementsByTagName(xmlNodePtr node, const xmlChar* name, size_t* len);

#if LIBXML_VERSION < 20700
xmlNodePtr xmlFirstElementChild(xmlNodePtr node);
xmlNodePtr xmlNextElementSibling(xmlNodePtr node);
xmlNodePtr xmlPreviousElementSibling(xmlNodePtr node);
#endif

#endif /* _XML_UTIL_H */
