---------------------------------------------------------------------------
--! @file   color_rosetta.lua
--! @brief  FLOW configuration example (ROSETTA 3rd Earth flyby)
--! @copyright Copyright 2010-2012 Japan Aerospace Exploration Agency
--
--
-- ROSETTA 3rd Earth flyby
--
-- Overview
--
-- This example creates a ROSETTA WAC simulation observed
-- at 2009-11-13T14:23:00. Refer to 'Rosetta Earth swingby
-- successful' to compare.
--
-- Reference
--   Rosetta Earth swingby successful
--   http://www.planetary.org/blog/article/00002212/
--
---------------------------------------------------------------------------

--
-- Kernel directories
--
generic_kernel_dir = "kernels/generic_kernels/"
rosetta_kernel_dir = "kernels/ROSETTA/kernels/"

--
-- Spice kernels.
-- (`..' means concat)
--
spice_kernels = {
   generic_kernel_dir .. "lsk/naif0010.tls",
   generic_kernel_dir .. "pck/pck00010.tpc",
   generic_kernel_dir .. "spk/planets/de421.bsp",
   rosetta_kernel_dir .. "fk/ROS_V18.TF",
   rosetta_kernel_dir .. "sclk/ROS_110405_STEP.TSC",
   rosetta_kernel_dir .. "ik/ROS_OSIRIS_V11.TI",
   rosetta_kernel_dir .. "spk/ORGR_______________00096.BSP",
   rosetta_kernel_dir .. "ck/ATPR_P091108000000_00086.BC",
}

--
-- star data
--
star_kernel = generic_kernel_dir .. "stars/hipparcos.bdb"
star_magnitude_limit = 4.0

--
-- view settings.
--
title = "Sample view from ROSETTA"
time = "2009-11-13T14:23:00"
basis_object = "ROSETTA"
basis_instrument_id = -226112 -- WAC
--basis_instrument_id = -226111 -- NAC
aberration_correction = "LT+S"

--
-- object texture and model
--
texture_file_dir   = "texture/"
object_table = {
  ["PLANET.EARTH"] = {
    {
      type = "texture-body",
      file = texture_file_dir .. "earth.jpg",
    },
  },
}

--
-- output objects
--
output_objects = {
   "SUN",
   "PLANETS",
   "STARS",
}

image_width  = 1024
image_height = 1024
