---------------------------------------------------------------------------
--! @file   df_hinode_sot.lua
--! @brief  FLOW configuration example (Dynamic Frame Example)
--! @copyright Copyright 2010-2012 Japan Aerospace Exploration Agency
--
--
-- Dynamic Frame (Hinode SOT)
--
-- Overview
--
-- This example simulates Venus Transit observed by HINODE SOT
-- at 2012-06-05T22:30:00.
-- Refer to Hinode Views 2012 Venus Transit to compare. 
--
-- Reference
--  Hinode Views 2012 Venus Transit
--  http://www.nasa.gov/mission_pages/hinode/venus_transit_hinode.html
--
---------------------------------------------------------------------------

--
-- Kernel directories
--
generic_kernel_dir = "./kernels/generic_kernels/"
hinode_kernel_dir  = "./HINODE_dummy/"

--
-- Spice kernels.
-- (`..' means concat)
--
spice_kernels = {
   generic_kernel_dir .. "lsk/naif0010.tls",
   generic_kernel_dir .. "pck/pck00010.tpc",
   generic_kernel_dir .. "spk/planets/de421.bsp",
   -- HINODE
   hinode_kernel_dir .. "fk/hinode.tf",
   hinode_kernel_dir .. "ik/hinode.ti",
   hinode_kernel_dir .. "spk/orbit.bsp",
}

star_kernel = generic_kernel_dir .. "stars/hipparcos.bdb"
star_magnitude_limit = 4.0

title = "HINODE SOT Venus Transit"
time = "2012-06-05T22:30:00"
basis_object = "HINODE"
basis_instrument_id = -999001 -- HINODE SOT (dummy)
aberration_correction = "LT+S"

--
-- object texture and model
--
texture_file_dir   = "texture/"
object_table = {
  ["SUN"] = {
    {
      type = "texture-body",
      file = texture_file_dir .. "sun.jpg",
    },
  },
  ["PLANET.VENUS"] = {
    {
      type = "texture-body",
      file = texture_file_dir .. "venus.jpg",
    },
  },
}

output_objects = {
   "SUN",
   "PLANETS",
   "STARS",
}

image_width  = 1024
image_height = 512
