/**
 * Notice:
 *   There is no HINODE's SPICE spk file, and the dummy
 *   orbit is created here.
 *
 *   HINODE has an average orbit altitude of 600 km above
 *   around the Earth. 
 *
 *   This file calculates the position 600km above from
 *   the Earth which lies the line between the Sun's center
 *   and the Earth's center.
 *
 *   In the calculated orbit, HINODE does not rotate from
 *   the Earth, and it is not ture, but it is convenient
 *   for the simulation of the Venus transit.
 */

#include <SpiceUsr.h>
#include <stdio.h>

const int UTC_LEN =  24;
const int ALTITUDE = 600; // 600[km]
const SpiceChar* utc1 = "2012-06-05T22:00:00";
const SpiceChar* utc2 = "2012-06-06T05:00:00";

int main() {
  SpiceDouble et, et1, et2;
  SpiceDouble sun[6], pos[3], lt;
  SpiceChar utc[UTC_LEN];
  SpiceDouble unit[3], dist;
  SpiceInt dim;
  SpiceDouble radii[3];
  
  furnsh_c("orbit.meta");

  utc2et_c(utc1, &et1);
  utc2et_c(utc2, &et2);
  

  bodvrd_c("EARTH", "RADII", 3, &dim, radii);
  
  for(et = et1; et < et2; ++et) {
    et2utc_c(et, "ISOC", 3, UTC_LEN, utc);
    spkezr_c("SUN", et, "J2000", "NONE", "EARTH", sun, &lt);
    unorm_c(sun, unit, &dist);
    vscl_c(radii[0]+ALTITUDE, unit, pos);
    printf("%s,%lf,%lf,%lf,%lf,%lf,%lf\n",
	   utc,
	   pos[0],pos[1],pos[2],
	   sun[3],sun[4],sun[5]);
  }
}
