---------------------------------------------------------------------------
--! @file   fov_polygon_vex.lua
--! @brief  FLOW configuration example (Polygonal FOV example)
--! @copyright Copyright 2010-2012 Japan Aerospace Exploration Agency
--
--
-- Polygonal FOV (VEX VMC)
--
-- Overview
--
-- Some instruments have polygonal shapes of their FOVs.
-- This example shows a simulation of Venus Express VMC
-- which has the octagonal FOV. 
--
---------------------------------------------------------------------------

--
-- Kernel directories
--
generic_kernel_dir = "kernels/generic_kernels/"
vex_kernel_dir     = "kernels/VEX/"

--
-- Spice kernels.
-- (`..' means concat)
--
spice_kernels = {
   generic_kernel_dir .. "lsk/naif0010.tls",
   generic_kernel_dir .. "pck/pck00010.tpc",
   generic_kernel_dir .. "spk/planets/de421.bsp",
   -- VEX
   vex_kernel_dir .. "ik/VEX_VMC_V04.TI",
   vex_kernel_dir .. "sclk/VEX_120904_STEP.TSC",
   vex_kernel_dir .. "spk/ORVV__100401000000_00301.BSP",
   vex_kernel_dir .. "ck/ATNV_P051109051109_00445.BC",
   vex_kernel_dir .. "fk/VEX_V09.TF",
}

--
-- star data
--
star_kernel = generic_kernel_dir .. "stars/hipparcos.bdb"
star_magnitude_limit = 4.0

--
-- view settings.
--
title = "VMC UV"
time = "2010-04-01T06:00:00"
basis_object = "VEX"
basis_instrument_id = -248640
aberration_correction = "LT+S"

--
-- output objects
--
texture_file_dir   = "texture/"
object_table = {
  ["PLANET.VENUS"] = {
    {
      type = "texture-body",
      file = texture_file_dir .. "venus.jpg",
    },
  },
}

--
-- output objects
--
output_objects = {
   "PLANET.VENUS",
}

image_width = 1024
image_height = 1032
