---------------------------------------------------------------------------
--! @file   pb_selene_tc.lua
--! @brief  FLOW configuration example (Pushbroom Example)
--! @copyright Copyright 2010-2012 Japan Aerospace Exploration Agency
--
--
-- Pushbroom (Kaguya TC)
--
-- Overview
--
-- This example simulates a push broom scanner.Kaguya Terrain Camera (TC)
-- adopted the push broom scanner, and the SPICE IK contains only one
-- line definition of FOV (4096 x 1). 
--
---------------------------------------------------------------------------

--
-- Kernel directories
--
generic_kernel_dir = "kernels/generic_kernels/"
kaguya_kernel_dir  = "kernels/SELENE/"

--
-- Spice kernels.
-- (`..' means concat)
--
spice_kernels = {
   generic_kernel_dir .. "lsk/naif0010.tls",
   generic_kernel_dir .. "pck/pck00010.tpc",
   generic_kernel_dir .. "spk/planets/de421.bsp",
   -- SELENE TC
   kaguya_kernel_dir .. "ik/SEL_TC_V01.TI",
   kaguya_kernel_dir .. "sclk/SEL_M_V01.TSC",
   kaguya_kernel_dir .. "spk/SEL_M_071020_081226_SGMI_05.BSP",
   kaguya_kernel_dir .. "ck/SEL_M_200805_S_V02.BC",
}

--
-- view settings.
--
title = "Sample view of SELENE TC"
basis_object = "SELENE"
basis_instrument_id = -131351
aberration_correction = "LT+S"

--
-- time
--
time_start = "2008-05-20T21:26:00"
time_end   = "2008-05-20T21:26:10"
time_step  = 0.0075

--
-- texture/model table
--
texture_file_dir = "texture/"
object_table = {
   ["SATELLITE.MOON"] = {
          {type       = "texture-body",
	   file       = texture_file_dir .. "selene_300,13,305,15.png",
	   region     = "300.0,13.0,305.0,15.0"}
   }
}

--
-- output objects
--
output_objects = {
   "SATELLITE.MOON",
}

image_width = 1
image_height = 4096
