---------------------------------------------------------------------------
--! @file   ring_saturn.lua
--! @brief  FLOW configuration example (Saturn rings Example)
--! @copyright Copyright 2010-2012 Japan Aerospace Exploration Agency
--
--
-- Saturn Ring (Cassini ISS NAC)
--
-- Overview
--
-- This example simulates the rings of Saturn obtained
-- by Cassini ISS NAC at 2004-03-27T13:10:00.
--  Refer to An 'Eyeful' of Saturn. to compare. 
--
-- Reference
--  An 'Eyeful' of Saturn
--  http://www.nasa.gov/multimedia/imagegallery/image_feature_168.html
--
---------------------------------------------------------------------------

--
-- Kernel directories
--
generic_kernel_dir = "kernels/generic_kernels/"
cassini_kernel_dir = "kernels/CASSINI/"

--
-- Spice kernels.
-- (`..' means concat)
--
spice_kernels = {
   generic_kernel_dir .. "lsk/naif0010.tls",
   generic_kernel_dir .. "pck/pck00010.tpc",
   generic_kernel_dir .. "spk/planets/de421.bsp",
   -- CASSINI
   cassini_kernel_dir .. "ik/cas_vims_v06.ti",
   cassini_kernel_dir .. "ik/cas_iss_v10.ti",
   cassini_kernel_dir .. "sclk/cas00155.tsc",
   cassini_kernel_dir .. "spk/041014R_SCPSE_01066_04199.bsp",
   cassini_kernel_dir .. "ck/04087_04094ra.bc",
   cassini_kernel_dir .. "fk/cas_v40.tf",
}

--
-- view settings.
--
title = "Saturn ring taken by Cassini ISS NAC"
time = "2004-03-27T13:10:00"
basis_object = "CASSINI"
basis_instrument_id = -82360
--basis_instrument_id = -82371
aberration_correction = "LT+S"

--
-- output objects
--
texture_file_dir   = "texture/"
object_table = {
  ["PLANET.SATURN"] = {
    {
      type = "texture-body",
      file = texture_file_dir .. "saturn.png",
    },
    {
      type = "texture-ring",
      file = texture_file_dir .. "saturn_ring.png",
      radius = "2.31",
    },
  },
}

--
-- output objects
--
output_objects = {
   "PLANET.SATURN",
}

image_width = 1024
image_height = 1024
