---------------------------------------------------------------------------
--! @file   stl_hayabusa.lua
--! @brief  FLOW configuration example (STL Polygon Example)
--! @copyright Copyright 2010-2012 Japan Aerospace Exploration Agency
--
--
-- Polygon model (Hayabusa AMICA) 
--
-- Overview
--
-- This example creates an asteroid Itokawa shot observed by Hayabusa
-- at 2005-10-10T07:35:40 which corresponds to product 'ST_2447883873_b'
-- in Hayabusa Project Science Data Archive. Rotate the simulated image
-- 90 degrees clockwise to compare. 
--
-- Reference
--   Hayabusa Project Science Data Archive
--   http://darts.isas.jaxa.jp/planet/project/hayabusa/amica.pl?phase=hp&date=20051010
--
---------------------------------------------------------------------------

--
-- Kernel directories
--
generic_kernel_dir  = "kernels/generic_kernels/"
hayabusa_kernel_dir = "kernels/HAYABUSA/"

--
-- Spice kernels.
-- (`..' means concat)
--
spice_kernels = {
   generic_kernel_dir .. "lsk/naif0010.tls",
   generic_kernel_dir .. "pck/pck00010.tpc",
   generic_kernel_dir .. "spk/planets/de421.bsp",
   -- HAYABUSA and ITOKAWA
   hayabusa_kernel_dir .. "ck/hayabusa_20051009_20051011_v01.bc",
   hayabusa_kernel_dir .. "spk/itokawa_1989_2010.bsp",
   hayabusa_kernel_dir .. "spk/hayabusa_itokawarendezvous_v01.bsp",
   hayabusa_kernel_dir .. "fk/hayabusa_hp.tf",
   hayabusa_kernel_dir .. "fk/itokawa_fixed.tf",
   hayabusa_kernel_dir .. "ik/amica31.ti",
   hayabusa_kernel_dir .. "sclk/hayabusa.tsc",
   hayabusa_kernel_dir .. "pck/itokawa_gaskell_n3.tpc",
}

--
-- star data
--
star_kernel = generic_kernel_dir .. "stars/hipparcos.bdb"
star_magnitude_limit = 4.0

--
-- view settings
--
title = "Hayabusa AMICA shoot ITOKAWA"
time = "2005-10-10T07:35:40"
basis_object = "HAYABUSA"
basis_instrument_id = -130102
aberration_correction = "LT+S"

--
-- object texture and model
--
texture_file_dir = "texture/"
model_file_dir   = "models/"
object_table = {
   ["ITOKAWA"] = {
	  {type = "model",
	   file = model_file_dir .. "itokawa_f0049152.stl",
	   scale = 1.0,
	   color = "204,204,204",
	   format = "STL"}
   }
}

--
-- output objects
--
output_objects = {
   "ITOKAWA",
   "STARS",
}

--
-- image size
--
image_width  = 1024
image_height = 1024
