#!/bin/sh

md5check()
{
	sum=$1
	target=$2
	md5=""
	md5cmd=$(which md5sum)
	if [ "$md5cmd" ] ; then
		md5=`md5sum $target | cut -f1 -d' '`
	else
		md5cmd=$(which md5)
		if [ "$md5cmd" ] ; then
			md5=`md5 $target | cut -f4 -d' '`
		else
			echo "neither md5 nor md5sum found"
			exit 1
		fi
	fi

	if [ "x$sum" != "x$md5" ] ; then
		return 1
	fi
	return 0
}

# check environment variables
if [ "x$FLOW_DATA_PREFIX" = x ] ; then
	echo "Notice: FLOW_DATA_PREFIX must be set !"
	echo "  SPICE kernels are stored into \$FLOW_DATA_PREFIX/kernels".
	echo "  Shape models are stored into \$FLOW_DATA_PREFIX/models".
	exit 1
fi

FLOW_DATA_PREFIX=`echo $FLOW_DATA_PREFIX | sed 's/\/\+/\//g' | sed 's/\/$//'`

if [ "x$SPICE_TOBIN" = x ] ; then
	echo "Notice: SPICE_TOBIN must be set !"
	echo "tobin is required to prepare hipparcos.bdb."
	echo "Check if there is (somewhere)/cspice/exe/tobin."
	exit 1
fi

# download kernels
cat download.lst | while read sum local remote; do
	target=$FLOW_DATA_PREFIX/$local

	# make directory
	dir=`dirname $target`
	if [ ! -d $dir ] ; then
		mkdir -p $dir
	fi

	# download file
	if [ ! -f $target ] ; then
		echo ""
		echo "------------------------------"
		echo "remote: $remote"
		echo "local : $target"
		echo ""
		curl --fail "$remote" -o $target
        if [ $? -ne 0 ]; then
            echo "=================================="
            echo "  Check the URL in download.lst."
            echo "=================================="
            exit 1
        fi
	fi

	# check md5 checksum
	md5check $sum $target
	if [ $? -ne 0 ] ; then
		echo "check sum error: $target"
		exit 1
	fi
done
if [ $? -ne 0 ]; then
	exit 1
fi

# make hipparocos.bdb
HIPPARCOS="$FLOW_DATA_PREFIX"/kernels/generic_kernels/stars/hipparcos
if [ ! -f $HIPPARCOS.bdb ] ; then
	if [ ! -f $HIPPARCOS.xdb ] ; then
		uncompress -c $HIPPARCOS.xdb.Z > $HIPPARCOS.xdb
	fi
	$SPICE_TOBIN $HIPPARCOS.xdb $HIPPARCOS.bdb
fi


KERNEL_DIR="$FLOW_DATA_PREFIX"/kernels
if [ ! -h kernels -a ! -d kernels ] ; then
	ln -s "$KERNEL_DIR" kernels
fi

MODEL_DIR="$FLOW_DATA_PREFIX"/models
if [ ! -h models -a ! -d models ] ; then
	ln -s "$MODEL_DIR" models
fi
