---------------------------------------------------------------------------
--! @file   wms_selene_hdtv.lua
--! @brief  FLOW configuration example (WMS example)
--! @copyright Copyright 2010-2014 Japan Aerospace Exploration Agency
--
--
-- Web Map Service (SELENE HDTV)
--
-- Overview
--
-- This example shows the simulation using Web Map Server
-- to overlay the lunar texture.
-- The target is a shot taken by SELENE HDTV WIDE at 2007-11-07T05:56:00.
--
-- Notice
--
--   This example is trying to connect the USGS Web Map Server
--   (http://onmoon.jpl.nasa.gov/wms.cgi). 
--
-- Reference
--   http://global.jaxa.jp/press/2007/11/20071113_kaguya_e.html
--   http://onmoon.jpl.nasa.gov/
--
---------------------------------------------------------------------------

--
-- Kernel directories
--
generic_kernel_dir = "kernels/generic_kernels/"
kaguya_kernel_dir  = "kernels/SELENE/"

--
-- Spice kernels.
-- (`..' means concat)
--
spice_kernels = {
   generic_kernel_dir .. "lsk/naif0010.tls",
   generic_kernel_dir .. "pck/pck00010.tpc",
   generic_kernel_dir .. "spk/planets/de421.bsp",
   -- SELENE HDTV
   kaguya_kernel_dir .. "ik/SEL_HDTV_V01.TI",
   kaguya_kernel_dir .. "sclk/SEL_M_V01.TSC",
   kaguya_kernel_dir .. "spk/SEL_M_071020_081226_SGMI_05.BSP",
   kaguya_kernel_dir .. "ck/SEL_M_200711_S_V02.BC",
}

--
-- star data
--
star_kernel = generic_kernel_dir .. "stars/hipparcos.bdb"
star_magnitude_limit = 4.0

--
-- view settings.
--
title = "Sample view of SELENE HDTV WIDE"
basis_object = "SELENE"
basis_instrument_id = -131820
aberration_correction = "LT+S"

--
-- time
--
time = "2007-11-07T05:56:00"

--
-- texture/model table
--
texture_file_dir   = "texture/"
object_table = {
  ["PLANET.EARTH"] = {
    {
      type = "texture-body",
      file = texture_file_dir .. "earth.jpg",
    },
  },
  ["SATELLITE.MOON"] = {
    {
      type = "texture-body",
      file = texture_file_dir .. "moon.png",
    },
    {
      type = "texture-body",
      wms_url    = "http://onmoon.jpl.nasa.gov/wms.cgi",
      wms_title  = "LRO Colorized and Shaded Elevation, second version",
      region     = "170.0,70.0,190.0,90.0",
      resolution = 50
    },
  },
}

output_objects = {
  "SATELLITE.MOON",
  "PLANET.EARTH",
  "STARS",
}

--
-- canvas
--
image_width = 1920
image_height = 1080
