cdef extern from "atFunctions.h":
    ctypedef struct AtEulerAng:
      double phi
      double theta
      double psi
    ctypedef struct AtPolarVect:
      double r
      double lon
      double lat
    ctypedef struct AtRightAscension:
      unsigned int hour
      unsigned int min
      double sec
    ctypedef struct AtDeclination:
      int sign
      unsigned int deg
      unsigned int min
      double sec
    ctypedef struct AtPolarVect60:
      AtRightAscension ra
      AtDeclination dec
    ctypedef struct AtTime:
      int yr
      int mo
      int dy
      int hr
      int mn
      int sc
      float ms
    ctypedef struct AtTimeD:
      int yr
      int mo
      int dy
      int hr
      int mn
      int sc
      double ss
    ctypedef struct AtElement:
      AtTime itz
      double semiax
      double eccent
      double aincln
      double ragome
      double smaome
      double omean0
      double adot
      double eccdot
      double aindot
      double ragdot
      double smodot
      double znbar
      double znbadt
      double mjdz
      double perige
      double apoge
    ctypedef struct AtElement3:
      AtTimeD itz
      AtTimeD itn
      double mjdz
      double mjdn
      double semiax
      double eccent
      double aincln
      double ragome
      double smaome
      double omean0
      double adot
      double eccdot
      double aindot
      double ragdot
      double smodot
      double znbar
      double znbadt
      double perige
      double apoge
    ctypedef struct AtRigData2:
      char *filename
      int nx
      int ny
      double attitude
      double *slon
      double *slat
      double *coeff
      double *data
      double work[1]
    ctypedef double[3][3] AtRotMat
    ctypedef double[3] AtVect
    ctypedef double[4] AtQuat

    # covert Right Ascension in hr,min,s to radian.
    double atRAToRadian(AtRightAscension ra);
    double atDecToRadian(AtDeclination dec);
    int atPol60ToVect(AtPolarVect60 *p, AtVect x);
    int atVectToPol60(AtVect x, AtPolarVect60 *p);
    int atVectToPolDeg(AtVect x, double *r, double *alpha, double *delta);
    int atPolDegToVect(double r, double alpha, double delta, AtVect x);

    # Basic coordinate conversion subroutines
    int atRotVect(AtRotMat rm, AtVect x, AtVect y);
    int atSetRotMat(AtVect axis, double roll, AtRotMat rm);
    int atSetRotMatZX(AtVect zAxis, AtVect xAxis, AtRotMat rm);
    int atInvRotMat(AtRotMat rm, AtRotMat rm2);
    int atNormVect(AtVect x, AtVect y);
    double atNorm(AtVect x);
    int atRMProd(AtRotMat rm0, AtRotMat rm1, AtRotMat rm2);
    int atRMCheck(AtRotMat rm);
    int atRMToEuler(AtRotMat rm, AtEulerAng *ea);
    int atEulerToRM(AtEulerAng *ea, AtRotMat rm);
    int atRMToQuat(AtRotMat rm, AtQuat q);
    int atQuatToRM(AtQuat q, AtRotMat rm);
    int atQuatProd(AtQuat q0, AtQuat q1, AtQuat q2);

    # Attitude and Orbit functions
    int atCopyVect(AtVect x, AtVect z);
    int atInvVect(AtVect x, AtVect y);
    int atAddVect(AtVect x, AtVect y, AtVect z);
    int atSubVect(AtVect x, AtVect y, AtVect z);
    int atMulVect(double f, AtVect x, AtVect z);
    int atDivVect(double d, AtVect x, AtVect z);
    int atMulAddVect(double f, AtVect x, double g, AtVect y, AtVect z);
    int atAngDistance(AtVect x, AtVect y, double *r);
    int atCrossPts(AtVect x, double r1, AtVect y, double r2, AtVect z[2]);
    int atVectProd(AtVect x, AtVect y, AtVect z);
    double atScalProd(AtVect x, AtVect y);
    int atSetEuler(AtPolarVect *z, AtPolarVect *y, AtEulerAng *ea);
    int atRotPVect(AtEulerAng *ea, AtPolarVect *x, AtPolarVect *y);
    int atVectToPol(AtVect x, AtPolarVect *y);
    int atPolToVect(AtPolarVect *x, AtVect y);
    int atConvPol(AtPolarVect60 *x, AtPolarVect *y);

    # time related function
    void atAtTimeToAtTimeD(AtTime *attime, AtTimeD *attimeD);
    void atAtTimeDToAtTime(AtTimeD *attimeD, AtTime *attime);
    int atReformatAtTime(AtTime *time);
    int atReformatAtTimeD(AtTimeD *time);
    int atCTime(AtTime *time, char *ctime);
    int atCTimeD(AtTimeD *time, char *ctime);
    int atCTime2(AtTime *time, char *ctime);
    int atCTimeD2(AtTimeD *time, char *ctime);
    int atMJulian(AtTime *time, double *mjd);
    int atMJulianD(AtTimeD *time, double *mjd);
    int atMJDate(double mjd, AtTime *time);
    int atMJDateD(double mjd, AtTimeD *time);
    void atMissionTimeResetTable();
    char *atMissionTimeInit(char *filename, int flag);
    int atAtTimeDToMission(double mjd_base, AtTimeD *attime, double *mission);
    int atMissionToAtTimeD(double mjd_base, double mission, AtTimeD *attime);
    int atMJDToMission(double mjd_base, double mjd, double *mission_time);
    int atMissionToMJD(double mjd_base, double mission_time, double *mjd);

    # Functions related to ephemeis and orbit
    int atPrecession(double mjd0, AtVect x0, double mjd, AtVect x);
    int atPrecessRM(double mjd0, double mjd, AtRotMat rm);
    int atPrecessEuler(double mjd0, double mjd, AtEulerAng *ea);
    void atPrecessRMJ2000(double mjd, AtRotMat rm);
    int atSaisa(double mjd0, AtPolarVect *pv0, double mjd, AtPolarVect *pv);
    int atSetElement(char *filename, double mjd0, int kchk);
    int atSetElement2(char *filename, double mjd0, int kchk);
    int atPathNum(double mjd, char path[11]);
    int atPathNumUSC(double mjd, char path[11]);
    int atSatPos(double mjd, AtVect x);
    int atSetElement3(AtElement3 *el, char *filename, double mjd0, int kchk);
    int atElementTime3(AtElement3 *el, double *mjdz, double *mjdn);
    int atPathNum3(AtElement3 *el, double mjd, char path[11]);
    int atPathNumUSC3(AtElement3 *el, double mjd, char path[11]);
    int atSatPos3(AtElement3 *el, double mjd, AtVect x);
    int atGeodcr(double mjd, AtVect x, double *heigh, double *longi, double *latt);
    int atGeodetic(double mjd, AtVect x, AtVect y);
    int atInvGeodetic(double mjd, AtVect x, AtVect y);
    int atEllipsoid(AtPolarVect *xp, double *latt, double *heigh);
    int atSetGeoRM(double mjd, AtRotMat rm);
    int atSidereal(double mjd, double *gsttod);
    int atKepler(double g, double eccent, double *e);
    int atOrbPlane(AtVect x, double ol, double ob, double ai, AtVect y);
    int atGeographic(AtPolarVect *y, AtVect z);
    int atGeographicToGeodetic(AtPolarVect *y, AtVect z);
    int atGeodesic(AtPolarVect *y, AtVect z);
    int atGeodeticToGeographic(AtVect vect, AtPolarVect *pv);
    int atGroundCoord(AtVect station, AtRotMat rm);
    int atAzElSet(AtPolarVect *y, AtVect vStation, AtRotMat stationRM);
    int atAzEl(AtVect x, AtVect stationV, AtRotMat stationRM, AtPolarVect *y);
    int atEarthOccult(AtVect satVect, AtVect xVect, AtVect sunVect, int *flag, double *el);
    int atRigSet(char *filename);
    int atRigidity(AtPolarVect *x, float *rig);
    int atRigidityD(AtPolarVect *x, double *rig);
    int atRigSet2(AtRigData2 **rdpp, char *filename);
    int atRigFree2(AtRigData2 *rdp);
    int atRigidity2(AtRigData2 *rdp, AtPolarVect *x, double *rig);
    int atGeomagSet(double mjd, int nmax);
    int atGeomag(AtPolarVect *x, AtVect xs, AtVect field);
    int atSun(double mjd, AtVect pos);
    int atPlanet(double mjd, AtVect pos[9], double size[9], double mag[9]);
    int atMoon(double mjd, AtVect pos, double *size, double *phase, double *distan);
    int atSAA(int saa_type, AtPolarVect *x, int *flag);
    int atBrazil(double lon, double lat, int *flag);
    int atSISBrazil(double lon, double lat, int *flag);
    int atSTTBrazil(double lon, double lat, int *flag);
    int atHXDBrazil(double lon, double lat, int *flag);

    ##############################
    # New for Astro-D
    ##############################

    int atBarycentric(double mjd, AtVect x, AtVect y);
    int atTDT(double mjd, double *tdt);

    ##############################
    # since version 1.8
    ##############################

    int atEarthElev(AtVect vSat, AtVect nvTgt, AtVect vSun, int *occlt, double elv[3]);
    void atAberration(double mjd, AtVect x0, AtVect x);
    void atInvAberration(double mjd, AtVect x0, AtVect x);
    void atJ2000toB1950(double lo2000,double la2000,double *lo1950,double *la1950);
    void atB1950toJ2000(double lo1950,double la1950,double *lo2000,double *la2000);
    void atJ2000toGal(double ra, double dec, double *gl, double *gb);
    void atGaltoJ2000(double gl, double gb, double *ra, double *dec);
    void atGaltoB1950(double gl, double gb, double *ra, double *dec);
    void atB1950toGal(double ra, double dec, double *gl, double *gb);
    void atJ2000ToEcliptic(double alpha, double delta, double *l, double *b);
    void atEclipticToJ2000(double l, double b, double *alpha, double *delta);
    void atRadianToRA(double radian, AtRightAscension *ra);
    void atDegToRA(double deg, AtRightAscension *ra);
    void atRadianToDec(double radian, AtDeclination *dec);
    void atDegToDec(double deg, AtDeclination *dec);
    double atParseRAToRadian(char *expression);
    double atParseDecToRadian(char *expression);

    ##############################
    # since version 2.5
    ##############################

    int atQuatToEuler(AtQuat q, AtEulerAng *ea);
    int atEulerToQuat(AtEulerAng *ea, AtQuat q);
    int atInterpolateQuat(double t0, AtQuat q0, double t1, AtQuat q1, double t, AtQuat q);
    int atInterpolateEuler(double t0, AtEulerAng *ea0, double t1, AtEulerAng *ea1, double t, AtEulerAng *ea);
